package cn.quantgroup.xyqb.service.security.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.model.AuthenticationUserDetail;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service("userDetailsService")
public class UserDetailsServiceImpl implements UserDetailsService {

    @Autowired
    private IUserService userService;

    @Override
    public UserDetails loadUserByUsername(String phoneNo) throws UsernameNotFoundException {
        User user = userService.findByPhone(phoneNo);
        if (user == null) {
            throw new UserNotExistException("未找到用户：" + phoneNo);
        }else if(! user.isEnable()){
            throw new UserNotExistException("用户已禁用：" + phoneNo);
        }
        return new AuthenticationUserDetail(user);
    }
}
