package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by FrankChow on 15/7/8.
 */
@Entity
@Table(name = "user_detail", uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
public class UserDetail implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "name")
    private String name;

    //证件号
    @Column(name = "id_no")
    private String idNo;

    //0 身份证 1 军官证 2 护照
    @Column(name = "id_type")
    private IdType idType;

    //身份证验真 0 未认证 1认证
    @Column(name = "is_authenticated")
    private Boolean isAuthenticated = false;

    //0 未知 1 女 2 男
    @Column(name = "gender")
    private Gender gender;

    @Column(name = "email")
    private String email;

    @Column(name = "qq")
    private String qq;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    //上一次修改时间
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public IdType getIdType() {
        return idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public Boolean getIsAuthenticated() {
        return isAuthenticated;
    }

    public void setIsAuthenticated(Boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public String toString() {
        return "UserDetail{" +
                "createdAt=" + createdAt +
                ", id=" + id +
                ", userId=" + userId +
                ", phoneNo='" + phoneNo + '\'' +
                ", name='" + name + '\'' +
                ", idNo='" + idNo + '\'' +
                ", idType=" + idType +
                ", isAuthenticated=" + isAuthenticated +
                ", gender=" + gender +
                ", email='" + email + '\'' +
                ", qq='" + qq + '\'' +
                ", updatedAt=" + updatedAt +
                '}';
    }
}
