package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.xyqb.model.sms.SmsResult;
import cn.quantgroup.xyqb.service.sms.ISmsSender;
import cn.quantgroup.xyqb.thirdparty.zhangzhongwuxian.Info;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

import static cn.quantgroup.xyqb.model.sms.SmsConfig.SMS.ZHANG_ZHONG_WU_XIAN;

/**
 * <pre>
 * 掌中无限短信平台
 * 返回值	说明
 * 0	成功
 * -1	用户名或密码不正确
 * -2	余额不够
 * -3	帐号没有注册
 * -4	内容超长
 * -5	账号路由为空
 * -6	手机号码多余1000个（或手机号码非法或错误）
 * -8	扩展号超长
 * -13	定时时间错误或者小于当前系统时间
 * -17	手机号码为空
 * -18	号码不是数字或者逗号不是英文逗号
 * -19	短信内容为空
 * 5    具体的禁发词	关键词的原因失败返回的值，逗号后面的中文实际返回时做了urlencode的编码转换（GBK字符集）。
 * -32 （包体异常）或网络故障
 * </pre>
 *
 * @author mengfan.feng
 * @time 2015-09-14 14:36
 */
@Service
public class ZhangZhongSms implements ISmsSender {

    private static final Map<String, String> ERRORS = ImmutableMap.<String, String>builder()
            .put("0", "成功")
            .put("-1", "用户名或密码不正确")
            .put("-2", "余额不够")
            .put("-3", "帐号没有注册")
            .put("-4", "内容超长")
            .put("-5", "账号路由为空")
            .put("-6", "手机号码多余1000个（或手机号码非法或错误）")
            .put("-8", "扩展号超长")
            .put("-13", "定时时间错误或者小于当前系统时间")
            .put("-17", "手机号码为空")
            .put("-18", "号码不是数字或者逗号不是英文逗号")
            .put("-19", "短信内容为空")
            .put("5", "具体的禁发词，关键词的原因失败")
            .put("-32", "（包体异常）或网络故障")
            .build();

    @Override
    public SmsResult send(String phone, String content) {

        String response = new Info().getInfoHttpPort().sendSMS(ZHANG_ZHONG_WU_XIAN.getAccount(), ZHANG_ZHONG_WU_XIAN.getPassword(), phone, content, "", "1", "", "1", "", "4");

        if (StringUtils.isBlank(response)) {
            return SmsResult.error("掌中无限短信平台，返回结果为空");
        }

        if ("0".equals(response)) {
            return SmsResult.success();
        }
        return SmsResult.error(ERRORS.get(response));
    }
}
