package cn.quantgroup.xyqb.service.security.impl;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import cn.quantgroup.user.UserSysResult;
import cn.quantgroup.user.bean.UserBean;
import cn.quantgroup.user.bean.UserDetailSaveBean;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.model.AppUserParam;
import cn.quantgroup.xyqb.model.AuthenticationUserDetail;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.Utils;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.Timestamp;
import java.util.Random;

/**
 * @author mengfan.feng
 * @time 2015-10-26 16:00
 */
@Service
public class UserDetailsByPhoneService implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsByPhoneService.class);

    @Autowired
    private IUserService userService;

    @Autowired
    private ILkbUserService lkbUserService;

    @Autowired
    private ISmsService smsService;
    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;



    private static final Random random = new Random();

    @Value("${usersys.url}")
    private String userSysUrl;
    private IUserSdkService userSdkService;
    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    @Override
    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        AppUserParam param = (AppUserParam) token.getPrincipal();
        User user = userService.findByPhone(param.getPhoneNo());

        if (user == null) {
            LOGGER.info("第三方登录用户不存在，开始注册，{}", param);
            user = this.register(param);
        }

        if (user == null) {
            throw new UserNotExistException(String.format("用户未找到, phone:%s", param.getPhoneNo()));
        }

        return new AuthenticationUserDetail(user);
    }

    /**
     * 注册新用户
     *
     * @param param
     * @return
     */
    private User register(AppUserParam param) {
        if (!ValidationUtil.validatePhoneNo(param.getPhoneNo())) {
            return null;
        }

        String randomCode = String.valueOf(random.nextInt(899999) + 100000);

        String uuid = lkbUserService.registerApp(param.getPhoneNo(), randomCode);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());

        LOGGER.info("第三方登录用户，保存 User");

        UserBean userBean = new UserBean();
        userBean.setRegisteredFrom(param.getRegisterFrom());
        userBean.setUpdatedAt(currentTime);
        userBean.setCreatedAt(currentTime);
        userBean.setPhoneNo(param.getPhoneNo());
        userBean.setPassword(PasswordUtil.MD5(randomCode + Constants.PASSWORD_SALT));
        userBean.setUuid(uuid);
        UserSysResult<XUser> result = userSdkService.saveUser(userBean);
        if (!result.isSuccess()) {
            throw new RuntimeException("保存用户出错");
        }
        User user = Utils.xuser2User(result.getData());

        // user = userRepository.saveAndFlush(user);

        smsService.sendAfterRegister(param.getPhoneNo());

        LOGGER.info("第三方登录用户注册成功, registerFrom:{}, phoneNo:{}, 并且已发送短信通知", param.getRegisterFrom(), param.getPhoneNo());

        if (StringUtils.isNotEmpty(param.getIdNo())) {
            LOGGER.info("第三方登录用户，保存 UserDetail");

            UserDetailSaveBean saveBean = new UserDetailSaveBean();
            saveBean.setIdNo(param.getIdNo());
            saveBean.setPhoneNo(user.getPhoneNo());
            saveBean.setUserId(user.getId());
            saveBean.setEmail("");
            saveBean.setName(param.getName());
            UserSysResult<XUserDetail> userDetailUserSysResult = userSdkService.saveUserDetail(saveBean);
            if (userDetailUserSysResult.isSuccess()) {
                return user;
            }

            lkbUserService.userUpdate(user.getUuid(), param.getName(), param.getIdNo());
        }
        return user;
    }

}
