package cn.quantgroup.xyqb.model.sms;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

/**
 * <?xml version="1.0" encoding="gbk"?>
 * <response>
 * <code>00</code>
 * <message>
 * <desmobile>13900000000</desmobile>
 * <msgid>200811041234253654785</msgid>
 * </message>
 * <message>
 * <desmobile>13400000000</desmobile>
 * <msgid>200811041234253654786</msgid>
 * </message>>
 * </response>
 *
 * @author mengfan.feng
 * @time 2015-09-14 15:02
 */
@Getter
@Setter
@ToString
@XmlRootElement(name = "response")
@XmlAccessorType(XmlAccessType.FIELD)
public class GuoDuResult {

    private String code;
    @XmlElement(name = "message")
    private List<Message> messages;

    @Getter
    @Setter
    @ToString
    @XmlAccessorType(XmlAccessType.FIELD)
    public static class Message {

        private String desmobile;
        private String msgid;
    }
}
