package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.util.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneOffset;

/**
 * Created by xuran on 2017/9/7.
 */
@Data
public class UserRegisterMqMessage implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long id;

    //手机号
    private String phoneNo;


    //第一次用户来源 channel_id
    private Long registeredFrom;

    //uuid
    private String uuid;

    private Boolean enable;

    //创建时间
    private Long createdAt;

    //上一次修改时间
    private Long updatedAt;

    public UserRegisterMqMessage(User user) {
        Long createTimeStamp = DateUtils.getTimestamp(user.getCreatedAt());
        Long updateTimeStamp = DateUtils.getTimestamp(user.getUpdatedAt());
        this.setId(user.getId());
        this.setPhoneNo(user.getPhoneNo());
        this.setEnable(user.getEnable());
        this.setRegisteredFrom(user.getRegisteredFrom());
        this.setUuid(user.getUuid());
        this.setCreatedAt(createTimeStamp);
        this.setUpdatedAt(updateTimeStamp);
    }
}
