package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.constant.IpLimiterProperties;
import cn.quantgroup.xyqb.model.JsonResult;
import com.alibaba.fastjson.JSON;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author hyuk
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping("/ip/limit")
public class IpLimitController {

    private final StringRedisTemplate stringRedisTemplate;
    
    private static final String TOKEN = "8n7y5y9UaKIOFqox";
    
    public static final String IP_LIMIT_STATUS_KEY = "xyqb_user:01:ip_limit_status:m10z";
    
    @GetMapping("/current-status/{token}")
    public JsonResult<String> getCurrentStatus(@PathVariable String token) {
        if (!Objects.equals(TOKEN, token)) {
            return JsonResult.buildErrorStateResult("非法访问", null);
        }
        String status = stringRedisTemplate.opsForValue().get(IP_LIMIT_STATUS_KEY);
        if (StringUtils.isEmpty(status)) {
            status = "0";
        }
        return JsonResult.buildSuccessResult("success", status);
    }
    
    @GetMapping("/status/set/{token}/{status}")
    public JsonResult<String> setStatus(@PathVariable String token, @PathVariable String status) {
        if (!Objects.equals(TOKEN, token)) {
            return JsonResult.buildErrorStateResult("非法访问", null);
        }
        if (!Objects.equals(status, "1") && !Objects.equals(status, "0")) {
            return JsonResult.buildErrorStateResult("非法访问", null);
        }
        stringRedisTemplate.opsForValue().set(IP_LIMIT_STATUS_KEY, status);
        return JsonResult.buildSuccessResult("success", status);
    }
    
    
    private final IpLimiterProperties ipLimiterProperties;
    
    @GetMapping("/properties")
    public JsonResult<String> getProperties() {
        return JsonResult.buildSuccessResult("success", JSON.toJSONString(ipLimiterProperties.getExtranetIps()));
    }
}
