package cn.quantgroup.xyqb.service.register;

import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Map;

/**
 * Created by liqing on 2017/12/5 0005.
 */
public abstract class AbstractUserRegisterService implements IUserRegisterService,ApplicationContextAware {

    private static Map<String, AbstractUserRegisterHandler> userRegisterHandlerMap = Maps.newConcurrentMap();
    private static final String USER_REGISTER_HANDLER_DEFAULT_KEY = "default";
    private static final String USER_REGISTER_HANDLER_EXT_KEY = "ext";

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        // 创建默认注册流程
        createDefaultUserRegisterHandler(applicationContext);
        // 创建扩展注册流程
        createExtUserRegisterHandler(applicationContext);
    }

    /**
     * 创建默认注册流程
     * 1、保存基本信息 - 2、保存用户详情 - 3、保存白条信息 - 4、发送短信 - 5、发送mq
     * @param applicationContext
     */
    protected AbstractUserRegisterHandler createDefaultUserRegisterHandler(ApplicationContext applicationContext){
        AbstractUserRegisterHandler baseUserRegisterHandler = applicationContext.getBean("baseUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler detailUserRegisterHandler = applicationContext.getBean("detailUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler btUserRegisterHandler = applicationContext.getBean("btUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler smsUserRegisterHandler = applicationContext.getBean("smsUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler mqUserRegisterHandler = applicationContext.getBean("mqUserRegisterHandler", AbstractUserRegisterHandler.class);
        baseUserRegisterHandler.setSuccessor(detailUserRegisterHandler);
        detailUserRegisterHandler.setSuccessor(btUserRegisterHandler);
        btUserRegisterHandler.setSuccessor(smsUserRegisterHandler);
        smsUserRegisterHandler.setSuccessor(mqUserRegisterHandler);
        userRegisterHandlerMap.put(USER_REGISTER_HANDLER_DEFAULT_KEY, baseUserRegisterHandler);
        return baseUserRegisterHandler;
    }

    /**
     * 创建扩展注册流程
     * 1、保存基本信息 - 2、保存用户详情 - 3、保存白条信息 - 4、保存用户地址 - 5、保存联系人
     * 5、发送短信 - 6、发送mq
     * @param applicationContext
     */
    protected AbstractUserRegisterHandler createExtUserRegisterHandler(ApplicationContext applicationContext){
        AbstractUserRegisterHandler baseUserRegisterHandler = applicationContext.getBean("baseUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler detailUserRegisterHandler = applicationContext.getBean("detailUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler btUserRegisterHandler = applicationContext.getBean("btUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler smsUserRegisterHandler = applicationContext.getBean("smsUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler mqUserRegisterHandler = applicationContext.getBean("mqUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler addressUserRegisterHandler = applicationContext.getBean("addressUserRegisterHandler", AbstractUserRegisterHandler.class);
        AbstractUserRegisterHandler contactUserRegisterHandler = applicationContext.getBean("contactUserRegisterHandler", AbstractUserRegisterHandler.class);
        baseUserRegisterHandler.setSuccessor(detailUserRegisterHandler);
        detailUserRegisterHandler.setSuccessor(btUserRegisterHandler);
        btUserRegisterHandler.setSuccessor(addressUserRegisterHandler);
        addressUserRegisterHandler.setSuccessor(contactUserRegisterHandler);
        contactUserRegisterHandler.setSuccessor(smsUserRegisterHandler);
        smsUserRegisterHandler.setSuccessor(mqUserRegisterHandler);
        userRegisterHandlerMap.put(USER_REGISTER_HANDLER_EXT_KEY, baseUserRegisterHandler);
        return baseUserRegisterHandler;
    }

    /**
     * 获取默认注册流程
     * @return
     */
    protected AbstractUserRegisterHandler getDefaultUserRegisterHandler(){
        AbstractUserRegisterHandler curUserRegisterHandler = userRegisterHandlerMap.get(USER_REGISTER_HANDLER_DEFAULT_KEY);
        if (curUserRegisterHandler == null){
            curUserRegisterHandler = createDefaultUserRegisterHandler(ApplicationContextHolder.getApplicationContext());
        }
        return curUserRegisterHandler;
    }

    /**
     * 获取扩展注册流程
     * @return
     */
    protected AbstractUserRegisterHandler getExtUserRegisterHandler(){
        AbstractUserRegisterHandler curUserRegisterHandler = userRegisterHandlerMap.get(USER_REGISTER_HANDLER_EXT_KEY);
        if (curUserRegisterHandler == null){
            curUserRegisterHandler = createExtUserRegisterHandler(ApplicationContextHolder.getApplicationContext());
        }
        return curUserRegisterHandler;
    }
}
