package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.util.JsonUtil;
import cn.quantgroup.xyqb.util.MqUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Created by liqing on 2017/12/4 0004.
 * 注册 - 发送mq
 * 失败不影响注册流程
 */
@Component("mqUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class MqUserRegisterHandler extends AbstractUserRegisterHandler {

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) {
        try {
            doHandleMqUserRegister(userRegisterParam);
        } catch (Exception e) {
            // 发送Mq失败不影响注册流程
            log.error("[exception][mqUserRegisterHandler_exception]userRegisterParam={},error={}",
                    JsonUtil.toJson(userRegisterParam), e);
        }
        if (successor != null){
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

    /**
     * 执行注册发送mq
     * @param userRegisterParam
     */
    private void doHandleMqUserRegister(UserRegisterParam userRegisterParam) {
        Long channelId = userRegisterParam.getChannelId();
        String dimension = userRegisterParam.getDimension();
        User user = userRegisterParam.getUser();
        MqUtils.sendRegisterMessage(channelId, dimension, user);
    }

}
