package cn.quantgroup.xyqb.config.http;

import cn.quantgroup.xyqb.filter.BehaviorInterceptor;
import cn.quantgroup.xyqb.filter.TokenInterceptor;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import org.hibernate.validator.HibernateValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.format.FormatterRegistry;
import org.springframework.stereotype.Component;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

@Component
public class MyWebMvcConfigurer extends WebMvcConfigurerAdapter {

  @Autowired
  private ISessionService sessionService;
  @Autowired
  private IQuantgroupCaptchaService quantgroupCaptchaService;

  @Override
  public void addFormatters(FormatterRegistry registry) {
    registry.removeConvertible(String.class, Enum.class);
    registry.addConverterFactory(new IntegerToEnumConverterFactory());
  }

  /**
   * 快速校验参数. 第一个出错后面的不用再校验了
   *
   * @return
   */
  @Bean
  public MethodValidationPostProcessor methodValidationPostProcessor() {
    MethodValidationPostProcessor postProcessor = new MethodValidationPostProcessor();
    ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
        .configure()
        .addProperty("hibernate.validator.fail_fast", "true")
        .buildValidatorFactory();
    Validator validator = validatorFactory.getValidator();
    postProcessor.setValidator(validator);
    return postProcessor;
  }

  @Override
  public void addInterceptors(InterceptorRegistry registry) {
      registry.addInterceptor(new TokenInterceptor(sessionService)).addPathPatterns("/v2/**")
              .excludePathPatterns("/v2/behavior/code");
      registry.addInterceptor(new BehaviorInterceptor(quantgroupCaptchaService)).addPathPatterns("/v2/**","/api/v2")
              .excludePathPatterns("/v2/behavior/code");
  }
}