package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashSet;

public class BehaviorInterceptor implements HandlerInterceptor {

    private final IQuantgroupCaptchaService quantgroupCaptchaService;
    public BehaviorInterceptor(IQuantgroupCaptchaService quantgroupCaptchaService){
        this.quantgroupCaptchaService = quantgroupCaptchaService;
    }
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String type = request.getHeader(Constants.X_BEHAVIOR_TYPE);
        if(StringUtils.isEmpty(type) || !StringUtils.isNumeric(type)){
           return true;
        }
        switch (Integer.parseInt(type)){
            case 1:
                //走极验逻辑
                return false;
            case 2:
                //走量化派图形验证逻辑
                String id =  request.getHeader(Constants.X_BEHAVIOR_ID);
                String imageValue = request.getHeader(Constants.X_BEHAVIOR_IMAGEVALUE);

                boolean result =  quantgroupCaptchaService.validQuantgroupCaptcha(id,imageValue);
                if(result){
                    return true;
                }else{
                    throw  new BizException(BizExceptionEnum.FAIL_VERIFY_CODE);
                }
            default:
                return true;
        }

    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        XyqbSessionContextHolder.releaseSession();
    }
}
