package cn.quantgroup.xyqb.util;

import org.apache.commons.lang.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Miraculous on 15/7/6.
 * 所有validate为真返回true， 否则返回false
 */
public class ValidationUtil {

    private static String regExp = "^((13[0-9])|(14[0-9])|(15[0-9])|(17[37680])|(18[0-9]))\\d{8}$";

    private static Pattern pattern = Pattern.compile(regExp);

    public static boolean validatePhoneNo(String phoneNo) {

        boolean lengthValid = StringUtils.isNotEmpty(phoneNo) && phoneNo.length() == 11 && StringUtils.isNumeric(phoneNo);

        if (!lengthValid) {
            return false;
        }

        Matcher matcher = pattern.matcher(phoneNo);

        return matcher.find();
    }

    public static boolean validateChannelId(Long channelId) {
        return channelId == 0L ? false : true;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        return false;
    }

}
