package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Created by liqing on 2017/12/4 0004.
 */
@Component("smsUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class SmsUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private ISmsService smsService;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) throws Exception {
        Long registerFrom = userRegisterParam.getRegisterFrom();
        String phoneNo = userRegisterParam.getPhoneNo();
        if (registerFrom != 645L && registerFrom != 900L && registerFrom != 158412L) {
            smsService.sendAfterRegister(phoneNo);
            log.info("第三方登录用户注册成功,registerFrom:{}, phoneNo:{},并且已发送短信通知", registerFrom, phoneNo);
        }else if(registerFrom == 900L){
            smsService.sendAfterRegister(phoneNo, "123");
            log.info("第三方(聚美)登录用户注册成功,registerFrom:{},phoneNo:{},并且已发送短信通知", registerFrom, phoneNo);
        }
        if (successor != null){
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

}
