package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IContactRepository;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.List;

/**
 * Created by liqing on 2017/12/5 0005.
 * 注册 - 联系人信息
 * 失败影响注册流程
 */
@Component("contactUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class ContactUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private IContactRepository contactRepository;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) throws Exception {
        String contact_str = userRegisterParam.getContacts();
        User user = userRegisterParam.getUser();
        if (StringUtils.isNotBlank(contact_str)) {
            List<Contact> contactList = JSONObject.parseObject(contact_str, new TypeReference<List<Contact>>() {});

            if (CollectionUtils.isNotEmpty(contactList)) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                convertContactList(user.getId(), contactList, 2, now);
                contactRepository.save(contactList);
            }
        }
        if (successor != null){
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

    /**
     * 转换联系人信息
     * @param userId
     * @param contacts
     * @param number
     * @param now
     */
    private void convertContactList(Long userId, List<Contact> contacts,int number, Timestamp now) {
        int count = 1;
        for (Contact c : contacts) {
            if (count > number) {
                break;
            }
            c.setId(null);
            c.setUserId(userId);
            c.setRelation(c.getRelation() == null ? Relation.OTHER : c.getRelation());
            c.setCreatedAt(now);
            c.setUpdateAt(now);
            count++;
        }
    }
}
