package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.util.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.text.ParseException;

/**
 * Created by liqing on 2017/12/4 0004.
 * 注册 - 用户详情
 * 失败不影响注册流程
 */
@Component("detailUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class DetailUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private IIdCardService idCardService;
    @Autowired
    private IUserDetailService userDetailService;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) throws Exception {
        try {
            doHandleUserDetailRegister(userRegisterParam);
        } catch (Exception e) {
            // 用户详情注册失败不影响主流程
            log.error("[exception][detailUserRegisterHandler_exception]userRegisterParam={},error={}",
                    JsonUtil.toJson(userRegisterParam), e);
        }
        if (successor != null){
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

    /**
     * 执行用户详情注册
     * @param userRegisterParam
     */
    private void doHandleUserDetailRegister(UserRegisterParam userRegisterParam) throws Exception {
        String phoneNo = userRegisterParam.getPhoneNo();
        String name = userRegisterParam.getName();
        String idNo = userRegisterParam.getIdNo();
        IdCardInfo cardInfo = idCardService.getIdCardInfoWithExceptions(idNo);
        UserDetail userDetail = new UserDetail();
        userDetail.setIdNo(cardInfo.getIdNo());
        userDetail.setPhoneNo(phoneNo);
        userDetail.setName(name);
        userDetail.setIdType(IdType.ID_CARD);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        userDetail.setCreatedAt(currentTime);
        userDetail.setUpdatedAt(currentTime);
        User user = userRegisterParam.getUser();
        userDetail.setUserId(user.getId());
        userDetail.setGender(cardInfo.getGender());
        userDetailService.saveUserDetail(userDetail);
    }
}
