package cn.quantgroup.xyqb.model.session;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by 11 on 2016/12/28.
 */
@Data
@NoArgsConstructor
public class SessionStruct implements Serializable {
    private static final long serialVersionUID = -1L;
    private String sid;
    private SessionValue values;
    private long expire;
    private Integer tenantId;
    private Integer registeredFrom;

    private String ip;

    public void setAttribute(String key, String value) {
        if (value == null) {
            value = "";
        }
        Map<String, String> t = values.getValues();
        if (t == null) {
            t = new HashMap<>();
        }
        t.put(key, value);
    }

    public String getAttribute(String key) {
        Map<String, String> t = values.getValues();
        if (t == null) {
            t = new HashMap<>();
        }
        return t.getOrDefault(key, "");
    }

}
