package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class LoginContext {
    private final Map<Integer, LoginStrategy> loginStrategyMap = new HashMap<>();

    private final Map<Integer,BehaviorStrategy> behaviorStrategyMap = new HashMap<>();

    public LoginContext(List<LoginStrategy> loginStrategies,List<BehaviorStrategy> behaviorStrategies) {
        loginStrategies.forEach(i -> loginStrategyMap.put(i.getType(), i));
        behaviorStrategies.forEach(i->behaviorStrategyMap.put(i.getType(), i));
    }

    public LoginBean login(LoginReq loginReq) {
        //第一步、校验参数
        LoginStrategy loginStrategy = loginStrategyMap.get(loginReq.getType());
        BaseLoginParam loginParam = loginStrategy.checkParam(loginReq);

        //第二步、进行行为验证
        if(loginReq.getBehavior()!=null){
            BehaviorStrategy behaviorStrategy= behaviorStrategyMap.get(loginReq.getBehavior().getType());
            behaviorStrategy.checkParam(loginReq.getBehavior());
        }

        //第三步、执行登录操作
        LoginBean loginBean = loginStrategy.login(loginParam);



        return loginStrategy.login(loginParam);
    }
}
