package cn.quantgroup.xyqb.controller.v2;

import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.service.v2.LoginContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/v2/oauth")
public class OauthV2Controller {

    private final LoginContext loginContext;

    public OauthV2Controller(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    @PostMapping("/login")
    public JsonResult<LoginBean> login(@RequestBody LoginReq loginReq){
        return JsonResult.buildSuccessResultGeneric(loginContext.login(loginReq));
    }
}
