package cn.quantgroup.xyqb.config.web;

import cn.quantgroup.xyqb.interceptors.ChannelIdInterceptor;
import cn.quantgroup.xyqb.interceptors.IPWhiteListInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Created by Miraculous on 15/7/10.
 */
@Configuration
public class InterceptorConfig extends WebMvcConfigurerAdapter {

  @Value("${configserver.disable}")
  private Integer isDebug;

  public void addInterceptors(InterceptorRegistry registry) {
    registry.addInterceptor(new IPWhiteListInterceptor(isDebug)).addPathPatterns("/**");
    registry.addInterceptor(new ChannelIdInterceptor()).addPathPatterns("/**");
  }

}
