package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.SMSReq;
import cn.quantgroup.xyqb.controller.req.v2.SMSVerifyReq;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.exception.SilentBizException;
import cn.quantgroup.xyqb.model.SMSCodeBean;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class VerificationCodeContext {

    private final ISmsService smsService;
    private final Map<Integer, VerificationCodeStrategy> verificationCodeStrategyHashMap = new HashMap<>();

    public VerificationCodeContext(List<VerificationCodeStrategy> verificationCodeStrategyList, ISmsService smsService) {
        this.smsService = smsService;
        verificationCodeStrategyList.forEach(i -> verificationCodeStrategyHashMap.put(i.getType(), i));
    }

    public SMSCodeBean send(SMSReq smsReq) {
        VerificationCodeStrategy verificationCodeStrategy = verificationCodeStrategyHashMap.get(smsReq.getType());
        if (verificationCodeStrategy == null) {
            throw new BizException(BizExceptionEnum.UN_EXIT_VERIFY_TYPE);
        }
        return verificationCodeStrategy.send(smsReq);
    }

    public boolean verify(SMSVerifyReq smsVerifyReq) {
        if (!smsService.verifyPhoneAndCode(smsVerifyReq)) {
            // 是否需要重新发送短信验证码
            if (smsService.needResendCode(smsVerifyReq.getPhoneNo())) {
                throw new SilentBizException(BizExceptionEnum.INVALID_SMS_CODE);
            }

            throw new SilentBizException(BizExceptionEnum.ERROR_SMS_CODE);
        }
        return true;
    }
}
