package cn.quantgroup.xyqb.util.encrypt;

import cn.quantgroup.xyqb.util.AESUtils;

import javax.persistence.AttributeConverter;

public class CryptConverter implements AttributeConverter<String, String> {

  @Override
  public String convertToDatabaseColumn(String attribute) {
    return AESUtils.encryptV2(attribute);
  }

  @Override
  public String convertToEntityAttribute(String dbData) {
    return AESUtils.decryptV2(dbData);
  }
}
