package cn.quantgroup.xyqb.service.api.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.model.UserFullInfo;
import cn.quantgroup.xyqb.model.UserInfoRet;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.service.api.IUserApiService;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * Created by FrankChow on 15/12/16.
 */
@Service
public class UserApiServiceImpl implements IUserApiService {

    @Autowired
    private IUserService userService;
    @Autowired
    private IUserInfoRepository userInfoRepository;

    @Override
    public Optional<UserFullInfo> getUserFullInfoByUuid(String uuid,Integer tenantId) {
        User user = userService.findByUuidWithCache(uuid,tenantId);
        if (null == user) {
            return Optional.empty();
        }
        UserInfoEntity detail = userInfoRepository.findByUserIdAndTenantId(user.getId(),user.getTenantId());
        UserFullInfo userFullInfo = new UserFullInfo(user, detail);
        return Optional.of(userFullInfo);
    }

    @Override
    public Optional<UserFullInfo> getUserFullInfoByPhone(String phoneNo,Integer tenantId) {
        User user = userService.findByPhoneInDb(phoneNo,tenantId);
        if (null == user) {
            return Optional.empty();
        }
        UserInfoEntity detail = userInfoRepository.findByUserIdAndTenantId(user.getId(),user.getTenantId());
        UserFullInfo userFullInfo = new UserFullInfo(user, detail);
        return Optional.of(userFullInfo);
    }
}
