package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * Created by Miraculous on 15/7/4.
 */
public interface IUserRepository extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {

    User findByPhoneNo(String phoneNo);

    User findByUuid(String uuid);

    /**
     * 根据手机号查询用户UUID
     * @param phoneNo - 手机号
     * @return user表的uuid
     */
    @Query(value = "select uuid from user where phone_no=?1", nativeQuery = true)
    String findUuidByPhoneNo(String phoneNo);

    /**
     * 根据身份证号查询用户UUID
     * @param idNo - 身份证号
     * @return user表的uuid
     */
    @Query(value = "select uuid from user where id=(select user_id from user_detail where id_no=?1) ", nativeQuery = true)
    String findUuidByIdNo(String idNo);

    List<User> findByIdIn(List<Long> ids);

    User findById(Long id);

    @Query(value = "select * from user where created_at>=?1 and created_at<?2 ", nativeQuery = true)
    List<User> findRegisterUserByTime(String beginTime, String endTime);

    @Transactional
    @Modifying
    @Query(value = "update user set enable=?1 where phone_no=?2", nativeQuery = true)
    int forbiddenUser(Boolean enable, String phoneNo);

    @Query(value = "select * from user where id >= ?1 limit ?2", nativeQuery = true)
    List<User> findByIdLimit(Long id, Long limit);

}
