package cn.quantgroup.xyqb.service.user;


/**
 * IPV4锁机制Service
 *
 * @author renwc
 */
public interface ILockIpv4Service {

    /**
     * 向该phoneNo添加错误计数器
     *
     * @param phoneNo
     */
    void countErrorByPhoneNo(String phoneNo);

    /**
     * 向该ipv4添加错误计数器
     *
     * @param ip - 目标ip
     */
    void countErrorByIpv4(String ip);

    /**
     * 锁定IPV4
     *
     * @param ip    - 目标ip
     * @param count - 错误计数
     */
    void lockErrorIpv4(String ip, long count);

    /**
     * 向该phoneNo添加错误计数器
     *
     * @param ip - 目标ip
     */
    void countSuccessByIpv4(String ip);

    /**
     * 锁定IPV4
     *
     * @param ip    - 目标ip
     * @param count - 错误计数
     */
    void lockSuccessIpv4(String ip, long count);

}
