package cn.quantgroup.xyqb.service.register.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDeregisterRecord;
import cn.quantgroup.xyqb.repository.IUserDeregisterRecordRepository;
import cn.quantgroup.xyqb.service.register.IUserDeregisterService;
import cn.quantgroup.xyqb.util.encrypt.Md5Util;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 销户服务实现
 *
 * @author killer
 * @date 2021年12月29日
 **/
@Slf4j
@Service
@RequiredArgsConstructor
public class IUserDeregisterServiceImpl implements IUserDeregisterService {

    private final IUserDeregisterRecordRepository userDeregisterRecordRepository;

    @Override
    public List<UserDeregisterRecord> queryByPhoneNo(String phoneNo) {
        return userDeregisterRecordRepository.findByPhoneNo(phoneNo);
    }

    @Override
    public void save(User user) {

        UserDeregisterRecord build = UserDeregisterRecord.builder()
                .deregisterTime(new Date())
                .phoneNo(Md5Util.build(user.getPhoneNo()))
                .build();
        userDeregisterRecordRepository.save(build);

    }

    @Override
    public void executeTask() {
        try {
            Date dt = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(dt);
            c.add(Calendar.DATE, -90);
            dt = c.getTime();
            log.info("执行删除超过90天注销记录--{}", dt);
            userDeregisterRecordRepository.deleteByDeregisterTimeIsBefore(dt);
        } catch (Exception e) {
            log.error("执行删除超过90天注销记录失败--{}", e.getMessage());
        }
    }
}
