package cn.quantgroup.xyqb.model;

import java.util.Optional;

/**
 * 验证场景类型
 *
 */
public enum SettingType {
    PASSWD("账密"), SMSLOGIN("短验");

    SettingType(String alias) {
        this.alias = alias;
    }

    private String alias;

    public String getAlias() {
        return this.alias;
    }

    public static SettingType valueByName(String name) {
        name = Optional.ofNullable(name).orElse("").toLowerCase();
        switch (name) {
            case "短验":
                return SMSLOGIN;
            default:
                return PASSWD;
        }
    }

}
