package cn.quantgroup.xyqb.filter;


import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by 11 on 2016/12/29.
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE + 100)
public class RequestFilter implements Filter {

    @Autowired
    private ISessionService sessionService;

    private AntPathMatcher matcher = new AntPathMatcher();
    private static final String [] ALLOWED_PATTERNS = {
        "/innerapi/**", "/user/exist","/user/register","/user/login","/user/register/fast",
            "/user/login/fast", "/user/reset_password","/user/exist_check",
            "/jr58/**","/app/login","/config/**","/api/**","/user/exists_token", "platform/api/page/return_url"
    };
    private static final String UNAUTH_RESULT = JSONObject.toJSONString(JsonResult.buildErrorStateResult("登录失败", null));

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestPath = getRequestPath(request);
        SessionStruct sessionStruct = null;
        if(!isMatch(requestPath)){
            //获取session信息,如果没有获取到session信息则返回错误信息
            sessionStruct = XyqbSessionContextHolder.getXSession();
            if(sessionStruct == null) {
                response.setStatus(200);
                response.setHeader("Content-Type", "application/json;charset=utf-8");
                PrintWriter writer = response.getWriter();
                writer.print(JSONObject.toJSONString(UNAUTH_RESULT));
                writer.close();
                return;
            }
            filterChain.doFilter(request, response);
            sessionStruct = XyqbSessionContextHolder.getXSession();
            if (sessionStruct == null) {
                return;
            }
            try {
                sessionService.persistSession(sessionStruct.getSid(), sessionStruct.getValues());
            } finally {
                XyqbSessionContextHolder.releaseSession();
            }
        }else {
            filterChain.doFilter(request, response);
        }

    }

    private boolean isMatch(String path) {
        for (String pattern : ALLOWED_PATTERNS) {
            if (matcher.match(pattern, path)) {
                return true;
            }
        }
        return false;
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();

        if (request.getPathInfo() != null) {
            url += request.getPathInfo();
        }
        return url;
    }

    @Override
    public void destroy() {

    }
}
