package cn.quantgroup.xyqb.service.register;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;

/**
 * Created by liqing on 2017/12/4 0004.
 */
public interface IUserRegisterService {

    /**
     * 以默认流程注册
     * @param userRegisterParam
     * @return
     * @throws Exception
     */
    User registerDefault(UserRegisterParam userRegisterParam);

    /**
     * 以扩展流程注册
     * @param userRegisterParam
     * @return
     * @throws Exception
     */
    User registerExt(UserRegisterParam userRegisterParam);

    /**
     * 替换AppController.register
     * /app/login，/app/login_super
     * @param registerFrom
     * @param phoneNo
     * @param idNo
     * @param name
     * @param channelId
     * @param btRegisterChannelId
     * @return
     */
    User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId, Long btRegisterChannelId);

    /**
     * 替换InnerController里的userService.registerAndReturn
     * /innerapi/user/register
     * @param phoneNo
     * @param password
     * @param registerFrom
     * @return
     */
    User register(String phoneNo, String password, Long registerFrom);

    /**
     * 替换UserController.register里的userService.register
     * /user/register
     * @param phoneNo
     * @param password
     * @param registerFrom
     * @param ip
     * @param channelId
     * @param btRegisterChannelId
     * @param dimension
     * @return
     */
    boolean register(String phoneNo, String password, Long registerFrom, String ip, Long channelId, Long btRegisterChannelId,String dimension);

    /**
     * 替换UserController.loginFast里的registerFastWhenLogin
     * /user/login/fast
     * @param phoneNo
     * @param channelId
     * @param registerFrom
     * @param appChannel
     * @param btRegisterChannelId
     * @param dimension
     * @return
     */
    User register(String phoneNo, Long channelId, Long registerFrom, String appChannel, Long btRegisterChannelId,String dimension);

    /**
     * 替换InnerController.saveMulti里的userService.registerAndReturn
     * /innserapi/user/save_multi
     * @param registeredFrom
     * @param channelId
     * @param phoneNo
     * @param name
     * @param idNo
     * @param provinceCode
     * @param province
     * @param cityCode
     * @param city
     * @param districtCode
     * @param district
     * @param address
     * @param contacts
     * @return
     */
    User register(Long registeredFrom, Long channelId, String phoneNo, String name, String idNo, String provinceCode, String province, String cityCode, String city, String districtCode, String district, String address, String contacts);

    /**
     * 替换MotanUserServiceImpl.appLoginAndFetchLoginInfo和MotanUserServiceImpl.appLogin里的register
     * @param registerFrom
     * @param phoneNo
     * @param idNo
     * @param name
     * @param channelId
     * @return
     */
    User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId);
}
