package cn.quantgroup.xyqb.controller.middleoffice.common;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * 基于短信策略的验证
 */
@Component
public class SmsVerifyStrategy implements IVerifyStrategy {

    @Resource
    private ISmsService smsService;

    @Override
    public VerifyTypeEnum strategyName() {
        return VerifyTypeEnum.sms;
    }

    @Override
    public void verify(User user, String verify) {
        String phoneNo = user.getPhoneNo();
        boolean smsValid = smsService.verifyPhoneAndCode(phoneNo, verify);
        if (smsValid) {
            return;
        }
        boolean needResend = smsService.needResendCode(phoneNo);
        if (needResend) {
            throw new VerificationCodeErrorException("短信验证码超时");
        }
        throw new VerificationCodeErrorException("短信验证码错误");
    }
}
