package cn.quantgroup.xyqb.controller.middleoffice.login;

import cn.quantgroup.xyqb.controller.middleoffice.common.VerifyTypeEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 注册与登陆
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/login")
public class LoginController {

    @Resource
    private ILoginModule loginModule;


    @PostMapping("/{type}")
    public JsonResult loginFreeAuto(@PathVariable VerifyTypeEnum type,
                                    @RequestParam(required = false, defaultValue = "false") Boolean autoReg,
                                    @RequestParam(required = false, defaultValue = "1") Long channelId,
                                    @RequestParam(required = false) String appChannel,
                                    @RequestParam(required = false) String wechatOpenId,
                                    @RequestParam String phoneNo,
                                    @RequestParam(required = false) String verify
    ) {
        LoginVo login = loginModule.login(type, autoReg, channelId, appChannel, wechatOpenId, phoneNo, verify);
        return JsonResult.buildSuccessResultGeneric(login);
    }

    @PatchMapping("/modify/pwd")
    public JsonResult modifyByPwd(String phoneNo, String password, String passwordNew) {
        loginModule.modifyPwd(VerifyTypeEnum.pwd, phoneNo, password, passwordNew);
        return JsonResult.buildSuccessResult();
    }

    @PatchMapping("/modify/sms")
    public JsonResult modifyBySms(String phoneNo, String password, String verificationCode) {
        loginModule.modifyPwd(VerifyTypeEnum.sms, phoneNo, password, verificationCode);
        return JsonResult.buildSuccessResult();
    }

}
