package cn.quantgroup.xyqb.controller.internal.user;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;
import java.text.ParseException;

/**
 * Created by Miraculous on 2017/1/3.
 */
@RestController
@RequestMapping("/user_detail")
public class UserDetailController implements IBaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailController.class);
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;
  private static final Long MAX_COUNTER = 1L;
  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> stringRedisTemplate;

  @RequestMapping("/save")
  public JsonResult saveUserdetail(String idNo, String name) {
    try {
      if (!ValidationUtil.validateChinese(name)) {
        return JsonResult.buildErrorStateResult("姓名错误", null);
      }
      IdCardInfo info = idCardService.getIdCardInfo(idNo);
      if (!info.isValid()) {
        return JsonResult.buildErrorStateResult("身份证号码错误", null);
      }
      User user = getCurrentUserFromRedis();
      if (user == null) {
        return JsonResult.buildErrorStateResult("系统错误", null);
      }
      Timestamp now = new Timestamp(System.currentTimeMillis());
      UserDetail userDetail = new UserDetail();
      userDetail.setIdNo(idNo);
      userDetail.setPhoneNo(user.getPhoneNo());
      userDetail.setUserId(user.getId());
      userDetail.setCreatedAt(now);
      userDetail.setUpdatedAt(now);
      userDetail.setName(name);
      userDetail.setGender(info.getGender());
      userDetail.setEmail("");
      userDetail.setIdType(IdType.ID_CARD);
      userDetail.setIsAuthenticated(false);
      userDetail.setQq("");
      try {
        userDetailService.saveUserDetail(userDetail);
      } catch (DataIntegrityViolationException ex) {
        return JsonResult.buildSuccessResult("", null);
      }
      return JsonResult.buildSuccessResult("", null);
    } catch (ParseException ex) {
      LOGGER.error("身份证号错误, idNo: {}", idNo);
      return JsonResult.buildErrorStateResult("身份证号码错误", null);
    }
  }

}
