package cn.quantgroup.xyqb.config.mq;

import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * Date: 2020/1/15
 * Time: 下午2:20
 *
 * @author: yangrui
 */
@Slf4j
@Configuration
public class RegisteredNotifyBlackHoleMqConfig {

    @Value("${registered.notify.black.hole.rabbitmq.connection.host}")
    private String host;
    @Value("${registered.notify.black.hole.rabbitmq.connection.port}")
    private Integer port;
    @Value("${registered.notify.black.hole.rabbitmq.connection.user}")
    private String user;
    @Value("${registered.notify.black.hole.rabbitmq.connection.password}")
    private String password;
    @Value("${registered.notify.black.hole.rabbitmq.connection.virtual-host}")
    private String virtualHost;

    @Resource
    private ITechRabbitBuilder techRabbitBuilder;

    @Bean(name = "registeredNotifyBlackHoleFactory")
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(true);
        connectionFactory.setPublisherConfirms(true);
        return connectionFactory;
    }

    @Bean(name = "registeredNotifyBlackHoleRabbitTemplate")
    public RabbitTemplate rabbitTemplate(@Qualifier("registeredNotifyBlackHoleFactory") ConnectionFactory connectionFactory) {
        return techRabbitBuilder.createRabbitTemplate(connectionFactory);
    }
}
