package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Optional;

/**
 * Created by Miraculous on 15/12/29.
 */
@Data
public class UserModel implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long id;

    private String name;

    private String phoneNo;

    private String idNo;

    private String gender;

    private String passwd;

    private Long registerFrom;

    private String uuid;

    public UserModel() {
    }

    public UserModel(User user, UserInfoEntity userDetail) {
        Assert.notNull(user, "User信息无效");
        this.id = user.getId();
        this.phoneNo = user.getPhoneNo();
        this.registerFrom = user.getRegisteredFrom();
        this.passwd = user.getPassword();
        this.uuid = user.getUuid();
        if (userDetail != null) {
            this.name = userDetail.getName();
            this.gender = Optional.ofNullable(userDetail.getGender()).orElse(Gender.UNKNOWN).getName();
        }
    }

}
