package cn.quantgroup.xyqb.config.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.ctrip.framework.apollo.ConfigService;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ContractTemplateConfiguration {
    private final Map<String, List<Long>> templateMap;

    public ContractTemplateConfiguration() {
        String data = ConfigService.getAppConfig().getProperty("template.data", "[]");
        templateMap = JSON.parseObject(data, new TypeReference<HashMap<String, List<Long>>>() {
        });
    }

    /**
     * 获取指定租户下指定registeredFrom的合同模版，如果没有配置，那么取租户下默认模板
     * @param tenantId 租户id
     * @param registeredFrom 来源
     * @return List<Long>
     */
    public List<Long> getByTenantIdAndRegisteredFrom(Integer tenantId, Long registeredFrom) {
        String key = tenantId + "_" + registeredFrom;
        List<Long> result = new ArrayList<>();
        if (templateMap.containsKey(key)) {
            result = templateMap.get(key);
        } else {
            if (templateMap.containsKey(tenantId.toString())) {
                result = templateMap.get(tenantId.toString());
            }
        }

        return result;
    }
}
