package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.*;
import cn.quantgroup.xyqb.repository.ICustomerInfoRepository;
import cn.quantgroup.xyqb.repository.ICustomerLoginRepository;
import cn.quantgroup.xyqb.repository.IOauthClientDetailsRepository;
import cn.quantgroup.xyqb.repository.IProductLoginRepository;
import cn.quantgroup.xyqb.service.user.IOauthClientDetailsService;
import cn.quantgroup.xyqb.service.user.IOauthLoginInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class OauthLoginInfoServiceImpl implements IOauthLoginInfoService {
    @Autowired
    private IOauthClientDetailsRepository oauthClientDetailsRepository;

    @Autowired
    private IProductLoginRepository productLoginRepository;

    @Autowired
    private ICustomerInfoRepository customerInfoRepository;

    @Autowired
    private ICustomerLoginRepository customerLoginRepository;

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void addLoginInfo(User user, Long clientId) {
        OauthClientDetailsEntity oauthClientDetailsEntity = oauthClientDetailsRepository.findFirstByClientId(clientId);
        String institutionId = oauthClientDetailsEntity.getInstitutionId();
        String productId = oauthClientDetailsEntity.getProductId();
        String phoneNo = user.getPhoneNo();
        Long userId = user.getId();
        ProductLoginEntity productLoginEntity = productLoginRepository.findFirstByInstitutionIdAndProductIdAndPhoneNo(institutionId, productId, phoneNo);
        String uuid = "";
        // 如果找不到该用户就创建
        if ("".equals(productLoginEntity) || productLoginEntity == null) {
            // 添加用户到产品登录表
            long customerId = 12321321;
//            long id = session.nextId();
            long id = 1212;
            String customerName = customerId + "";
            uuid = UUID.randomUUID().toString();
            ProductLoginEntity entity = new ProductLoginEntity();
//            Integer partitionKey = session.partitionKey(customerId);
            Integer partitionKey = 2;
            productLoginEntity = EntityBuilder.productLogin(productId, institutionId, phoneNo, customerId, customerName, partitionKey, id);
            productLoginEntity.setExtensionAccountId(userId);
            productLoginRepository.save(productLoginEntity);
            // 根据customerId 获取uuid
            CustomerLoginEntity customerLoginEntity = customerLoginRepository.findFirstByCustomerId(productLoginEntity.getCustomerId());
            if (null != customerLoginEntity) {
                uuid = customerLoginEntity.getUuid();
            }

            // 添加用户到登录表
            CustomerLoginEntity customerLogin = new CustomerLoginEntity();
            customerLogin.setId(12312312);
            customerLogin.setInstitutionId(institutionId);
            customerLogin.setProductId(productId);
            customerLogin.setCustomerId(customerId);
            customerLogin.setUuid(uuid);
            customerLogin.setPartitionKey(partitionKey);
            customerLogin.setCreatedDate(new Date());
            customerLogin.setModifiedDate(new Date());
            customerLogin.setCreatedBy("");
            customerLogin.setModifiedBy("");
            customerLoginRepository.save(customerLogin);

            // 添加用户信息表
            CustomerInfoEntity customerInfo = new CustomerInfoEntity();
            customerInfo.setId(1231111111);
            customerInfo.setCustomerId(customerId);
            customerInfo.setInstitutionId(institutionId);
            customerInfo.setProductId(productId);
            customerInfo.setPartitionKey(partitionKey);
            customerInfo.setCreatedDate(new Date());
            customerInfo.setModifiedDate(new Date());
            customerInfo.setCreatedBy("");
            customerInfo.setModifiedBy("");
            customerInfoRepository.save(customerInfo);

        }
    }

}
