package common;

import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Slf4j
@RunWith(JUnit4.class)
public class ValidationUtilTest {

    public static void main(String[] args){
        String[][] contacts = {
                {"18589336973","刘䶮"},
                {"13198898119","张鑫鑫"},
                {"16620800072","许慧梓"},
                {"1508964071 ","1508964071 "},
                {"16603429800","张泽浩"},
                {"17393151197","李小林？"},
                {"17393151197","高晓辉.买买提"},
                {"17393151197","高晓辉·喀秋莎.买买提"},
                {"17393151197","高晓辉·喀秋莎"},
                {"18721920553","王正\u202D"},
                {"15242331122","\u200D刘玥盈"}
        };
        for(String[] ctc : contacts) {
            log.info("phoneNo:[{}][{}],name:[{}][{}],name-trim:[{}][{}]",
                    ctc[0],ValidationUtil.validatePhoneNo(ctc[0]),
                    ctc[1], ValidationUtil.validateChinese(ctc[1]),
                    ctc[1].trim(),ValidationUtil.validateChinese(ctc[1].trim()));
        }
    }

    @Test
    public void testString() {
        assert true;
    }

}
