package cn.quantgroup.xyqb.controller.internal.login;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by Miraculous on 2016/12/30.
 */
@RestController
@RequestMapping("/auth")
public class AuthInfoController implements IBaseController {

    @RequestMapping("/info/login")
    public JsonResult loginInfo() {
        SessionStruct sessionStruct = getSessionStruct();
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUser(sessionStruct.getValues().getUser());
        LoginInfo.LoginContext context = new LoginInfo.LoginContext();
        context.setChannelId(getChannelId());
        context.setCreatedFrom(getCreatedFrom());
        context.setAppChannel(getAppChannel());
        loginInfo.setLoginContext(context);
        return JsonResult.buildSuccessResult("", loginInfo);
    }

}
