package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Data
public class ModifyRejectRecord {
  @NotNull(message = "用户id不能为空")
  private Long userId;

  @NotBlank(message = "原手机号不能为空")
  @Pattern(regexp = ValidationUtil.phoneRegExp, message = "原手机号码格式错误")
  private String prevPhoneNo;

  @NotBlank(message = "新手机号不能为空")
  @Pattern(regexp = ValidationUtil.phoneRegExp, message = "新手机号码格式错误")
  private String curPhoneNo;

  private String remark;

  @NotBlank(message = "拒绝原因不能为空")
  private String rejectReason;

}
