package cn.quantgroup.xyqb.event;

import cn.quantgroup.user.enums.UserStatusEnum;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.service.http.IHttpService;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/7/14 15:47
 * @description：激活或者注销用户事件监听
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@Async
@Component
public class DisableActiveEventListner implements ApplicationListener<DisableActiveEvent> {

    //消息中心营销短信黑名单 - （注销/激活）专用
    public static final String SMS_MARKET_BLACK_LIST = "/middle_office/sms_market_black_list/flush";

    @Autowired
    private IHttpService httpService;
    @Value("${mo-msg.http}")
    private String msgCenter;

    @Override
    public void onApplicationEvent(DisableActiveEvent disableActiveEvent) {

        User user = disableActiveEvent.getUser();

        if (null == user) {
            return;
        }

        String userId = String.valueOf(user.getId());
        String phoneNo = user.getPhoneNo();
        boolean enable = !UserStatusEnum.isDisable(user).getKey();

        String post = httpService.postJson(msgCenter.concat(SMS_MARKET_BLACK_LIST),
                ImmutableMap.of("userId", userId,
                        "phoneNo", phoneNo,
                        "enable", String.valueOf(!enable)));//true代表消息中心的注销false代表激活跟用户中心是反的

        log.info("通知消息中心激活/注销用户结束user:{} ,post：{} ", user, post);
    }
}
