package cn.quantgroup.xyqb.controller.external.queryLog;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserQueryLog;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.PageModel;
import cn.quantgroup.xyqb.model.UserQueryInfo;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserQueryLogService;

import cn.quantgroup.xyqb.util.IdcardValidator;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;


import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletResponse;

import static com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation.ANONYMOUS.required;

/**
 * Created by zenglibin on 17/06/13.
 */
@RestController
@RequestMapping("/query")
public class UserQueryLogController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserQueryLogController.class);

  @Autowired
  private IUserQueryLogService userQueryLogService;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IAddressService addressService;

  @Value("${xyqb.paycenter.url}")
  private String payCenterUrl;
  @Value("${xyqb.paycenter.id}")
  private String payCenterId;

  @Autowired
  private IHttpService httpService;

  @RequestMapping("/queryLog")
  public JsonResult queryLog(@RequestParam(required=false) String beginDate,@RequestParam(required=false) String endDate, Integer pageId, Integer pageSize) {

      try{
        SimpleDateFormat sf=new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        Date date1=null,date2=null;
        if(beginDate!=null&& StringUtils.hasLength(beginDate)){
          date1=sf.parse(beginDate);
        }else{
          date1=new Date();
        }
        if(endDate!=null&& StringUtils.hasLength(endDate)){
          date2=sf.parse(endDate);
        }else{
          date2=new Date();
        }

        List<UserQueryLog> userQueryLogs=userQueryLogService.findByTimestamp(date1,date2,pageId-1,pageSize);
        Long total=userQueryLogService.findByTimestampCount(date1,date2);
        PageModel<UserQueryLog> uqp=new PageModel<UserQueryLog>();
        uqp.setTotal(total);
        uqp.setPageSize(pageSize);
        uqp.setPageId(pageId);
        uqp.setPageList(userQueryLogs);
        Double d=Math.ceil(total/pageSize);
        uqp.setPages(d.intValue());
        return JsonResult.buildSuccessResult("查询成功",uqp);

      }catch(Exception e){
        return JsonResult.buildErrorStateResult("查询失败",null);
      }


  }

  @RequestMapping("/queryUserInfo")
  public JsonResult queryForResult(String key,String keyValues,String userName, String columns,Integer pageId,Integer pageSize) {

    //columns=>  userId,phoneNo,idNo,bankCard,address
    //key=>phoneNo、idNo、userId
    //checkKeysType;
    //后台参数校验

    String[] values=keyValues.split(";");
    List<String> queryV= Arrays.asList(values);
    List<UserQueryInfo> userQueryInfos=new ArrayList<UserQueryInfo>();
    Page<UserQueryInfo> userQueryInfoPage=null;
    List<UserDetail> userDetails=new ArrayList<UserDetail>();
    Page<UserDetail> userDetailPage=null;
    List<Address> addresslist=new ArrayList<Address>();
    if(key.equals("userId")){
      List<Long> userIds=new ArrayList<Long>();
      try{
        for(String s:queryV){
          if(s.length()>8){
            return JsonResult.buildErrorStateResult("查询的userId长度超过8位",s);
          }
          long uid=Long.valueOf(s);
          userIds.add(uid);
        }

      }catch(Exception e){
        return JsonResult.buildErrorStateResult("查询的userId有误",null);
      }

      userDetailPage=userDetailService.getUserDetailsPage(userIds,null,null,pageId,pageSize,"auto");
    }else if(key.equals("phoneNo")){
      for(String pn:queryV){
        if(!ValidationUtil.validatePhoneNo(pn)){
          return JsonResult.buildErrorStateResult("查询的手机号码格式有误",pn);
        }
      }

      userDetailPage=userDetailService.getUserDetailsPage(null,queryV,null,pageId,pageSize,"auto");
    }else if(key.equals("idNo")){
      IdcardValidator iv = new IdcardValidator();
      for(String idno:queryV){
        if(!iv.is18Idcard(idno)&&!iv.is15Idcard(idno)){
          return JsonResult.buildErrorStateResult("查询的身份证号格式有误",idno);
        }
      }
      userDetailPage=userDetailService.getUserDetailsPage(null,null,queryV,pageId,pageSize,"auto");
    }

    if(userDetailPage!=null){
      userDetails=userDetailPage.getContent();
    }

    if(columns.contains("bankCard")){
      //需加银行卡信息
    }

    if(columns.contains("address")){
      List<Long> uidss=new ArrayList<Long>();
      //加地址信息
      for(UserDetail ud:userDetails){
        uidss.add(ud.getUserId());
      }
      if(uidss!=null&&uidss.size()>0){
        addresslist=addressService.findByUserIds(uidss);
      }

    }

    //转换userDetail to userQueryInfo
    for(UserDetail ud:userDetails){
      UserQueryInfo uqi=new UserQueryInfo();
      if(columns.contains("idNo")){
        uqi.setIdNo(ud.getIdNo());
      }
      if(columns.contains("phoneNo")){
        uqi.setPhoneNo(ud.getPhoneNo());
      }
      if(columns.contains("userId")){
        uqi.setUserId(ud.getUserId());
      }
      if(columns.contains("address")){
        Optional<Address> oad=addresslist.stream().filter(addr->addr.getUserId()==ud.getUserId()).findFirst();
        if(oad.isPresent()){
          uqi.setAddress(oad.get().toString());
        }
      }
      userQueryInfos.add(uqi);

    }

    //保存记录
    UserQueryLog log=new UserQueryLog();
    log.setQueryItems(columns);
    log.setResultAmount(Long.valueOf(userQueryInfos.size()));
    log.setQueryCondition(key);
    log.setQueryDetail(keyValues);
    log.setLoginUserName(userName);
    if(keyValues!=null&&keyValues.length()<=2048){
      log.setQueryDetail(keyValues);
    }else{
      log.setQueryDetail(keyValues.substring(0,2048));
    }
    userQueryLogService.save(log);

    PageModel<UserQueryInfo> uqi=new PageModel<UserQueryInfo>();
    uqi.setPageId(pageId);
    uqi.setPageList(userQueryInfos);
    uqi.setPageSize(pageSize);
    uqi.setPages(userDetailPage.getTotalPages());
    uqi.setTotal(userDetailPage.getTotalElements());

    return JsonResult.buildSuccessResult("成功",uqi);
  }

  private String getBankCardsByPhoneNos(String phoneNo){

//    HashMap<String, String> parameters = new HashMap<>();
//    parameters.put("phoneNo", phoneNo);
//    parameters.put("merchantId", payCenterId);
//    //访问用户中心查询用户银行卡接口
//    String resultStr = httpService.post(payCenterUrl + "ex/common_bank_card/list", parameters);
//    StringBuffer cardList=null;
//    try{
//      JsonObject obj = new JsonParser().parse(resultStr).getAsJsonObject();
//      if(obj.get("data")!=null){
//        JsonArray array = obj.get("data").getAsJsonArray();
//        for(JsonElement jsonElement : array){
//          JsonObject jo = jsonElement.getAsJsonObject();
//          String cardNo=jo.get("cardNo").getAsString();
//          cardList.append(cardNo+",");
//        }
//      }
//
//    }catch(Exception e){
//
//    }
//    return cardList.toString();
    return null;
  }

  @RequestMapping("/exportUserInfo")
  public void exportExcel(final HttpServletResponse response,String key,String keyValues,String userName, String columns){
    List<UserQueryInfo> uqls=new ArrayList<UserQueryInfo>();
    UserQueryInfo uq=new UserQueryInfo();
    uq.setUserId(123l);
    uq.setAddress("AAAAAAA");
    uq.setPhoneNo("15840001232");
    uq.setIdNo("362529199701235671");
    uq.setBankCards("6217564445877112");
    uqls.add(uq);

    HSSFWorkbook wb = new HSSFWorkbook();
    // 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
    HSSFSheet sheet = wb.createSheet("用户信息列表");
    // 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
    HSSFRow row = sheet.createRow((int) 0);
    // 第四步，创建单元格，并设置值表头 设置表头居中
    HSSFCellStyle style = wb.createCellStyle();
    style.setAlignment(HSSFCellStyle.ALIGN_CENTER); // 创建一个居中格式

    HSSFCell cell = row.createCell((short) 0);
    cell.setCellValue("userId");
    cell.setCellStyle(style);
    cell = row.createCell((short) 1);
    cell.setCellValue("手机号");
    cell.setCellStyle(style);
    cell = row.createCell((short) 2);
    cell.setCellValue("身份证号");
    cell.setCellStyle(style);
    cell = row.createCell((short) 3);
    cell.setCellValue("银行卡号");
    cell.setCellStyle(style);

    cell = row.createCell((short) 4);
    cell.setCellValue("地址");
    cell.setCellStyle(style);

    // 第五步，写入实体数据 实际应用中这些数据从数据库得到，
    //List list = CreateSimpleExcelToDisk.getStudent();

    for (int i = 0; i < uqls.size(); i++)
    {
      row = sheet.createRow((int) i + 1);
      UserQueryInfo user = (UserQueryInfo) uqls.get(i);
      // 第四步，创建单元格，并设置值
      row.createCell((short) 0).setCellValue( user.getUserId());
      row.createCell((short) 1).setCellValue(user.getPhoneNo());
      row.createCell((short) 2).setCellValue(user.getIdNo());
      row.createCell((short) 3).setCellValue(user.getBankCards());
      row.createCell((short) 4).setCellValue(user.getAddress());

    }
    // 第六步，将文件存到指定位置
    try
    {
      OutputStream output=response.getOutputStream();
      response.reset();
      response.setHeader("Content-disposition", "attachment; filename=users.xls");
      response.setContentType("application/msexcel");
      wb.write(output);
      output.close();

    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

}
