package cn.quantgroup.xyqb.model.jr58;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * Created by Rocky on 2016/8/17.
 */
@Getter
@Setter
@ToString
public class Jr58Authorization {
  private String userId;
  private String sourceFrom;
  private String authorizationData;
  private OperatorData operator_data;

  @Getter
  @Setter
  public static class OperatorData {
    private OriginalData originalData;
    private ReportData reportData;

    @Getter
    @Setter
    public static class OriginalData {
      private String phone;
      private PhoneData phoneData;
      private PhoneBillDataList[] phoneBillDataList;
      private PhoneCallLogList[] phoneCallLogList;
      private PhoneSmsLogList[] phoneSmsLogList;

      @Getter
      @Setter
      public static class PhoneData {
        private Long id;
        private String phoneNum;
        private String serialNo;
        private String realName;
        private String idCard;
        private String sourceName;
        private String authorizeChannel;
        private String createTime;
        private String updateTime;
      }

      @Getter
      @Setter
      public static class PhoneBillDataList {
        private String localPhone;
        private String totalCost;
        private String planCost;
        private String yearMnth;
        private String authorizeChannel;
      }


      @Getter
      @Setter
      public static class PhoneCallLogList {
        private String localPhone;
        private String callPhone;
        private String callId;
        private String cost;
        private String callType;
        private String callStyle;
        private String callDuration;
        private String callTime;
        private String callAddress;
        private String authorizeChannel;
      }

      @Getter
      @Setter
      public static class PhoneSmsLogList {
        private String localPhone;
        private String otherPhone;
        private String sendId;
        private String totalCost;
        private String sendAddress;
        private String sendTime;
        private String authorizeChannel;
      }

    }


    @Getter
    @Setter
    public static class ReportData {
      private String localPhone;
      private Behavior behavior;
      private Check check;
      private CallList[] callList;
      private ContactList[] contactList;
      private OperatorList[] operatorList;
      private RegionList[] regionList;
      private ServiceList[] serviceList;
      private TripConsumeList[] tripConsumeList;

      @Getter
      @Setter
      public static class Behavior {
        private String localPhone;
        private String friendCircle;
        private String localLivingYear;
        private String powerOff;
        private String callMacao;
        private String call110;
        private String call120;
        private String callLawyer;
        private String callCourt;
        private String callLoan;
        private String callBank;
        private String callCredit;
        private String useTime;
        private String contactAmount;
        private String contactFrequency;
        private String livingLocation;
        private String workingLocation;
        private String nightUse;
        private String authorizeChannel;

      }

      @Getter
      @Setter
      public static class Check {
        private String localPhone;
        private String idCardValidate;
        private String operatorBinding;
        private String nameOperatorMatch;
        private String idcardOperatorMatch;
        private String nameIdcardBlack;
        private String namePhoneBlack;
        private String callContact;
        private String callHome;
        private String callWork;
        private String authorizeChannel;
      }


      @Getter
      @Setter
      public static class CallList {
        private String localPhone;
        private String phoneNum;
        private String attribution;
        private String contactName;
        private String needsType;
        private String callCount;
        private String callInCount;
        private String callOutCount;
        private String callTime;
        private String callInTime;
        private String callOutTime;
        private String relationSpeculate;
        private String contact1week;
        private String contact1month;
        private String contact3month;
        private String contact3monthMore;
        private String contactEarlyMorning;
        private String contactMorning;
        private String contactNoon;
        private String contactAfternoon;
        private String contactNight;
        private String contactWeekday;
        private String contactWeekend;
        private String contactHoliday;
        private String contactAllDay;
        private String authorizeChannel;

      }


      @Setter
      @Getter
      public static class ContactList {

      }


      @Getter
      @Setter
      public static class OperatorList {
        private String localPhone;
        private String operatorName;
        private String operatorZh;
        private String phoneNum;
        private String attribution;
        private String mnth;
        private String callCount;
        private String callInCount;
        private String callOutCount;
        private String callInTime;
        private String callOutTime;
        private String flow;
        private String smsCount;
        private String totalAmount;
        private String authorizeChannel;

      }


      @Getter
      @Setter
      public static class RegionList {
        private String localphone;
        private String regionName;
        private String numCount;
        private String callInCount;
        private String callOutCount;
        private String callInTime;
        private String callOutTime;
        private String callInAvg;
        private String callOutAvg;
        private String callInCountPct;
        private String callOutCountPct;
        private String callInTimePct;
        private String callOutTimePct;
        private String authorizeChannel;

      }


      @Setter
      @Getter
      public static class ServiceList {
        private String localPhone;
        private String companyName;
        private String companyType;
        private String contactTimes;
        private String contactMonth;
        private String contactTimesMonth;
        private String authorizeChannel;
      }


      @Setter
      @Getter
      public static class TripConsumeList {

      }

    }
  }


}
