package cn.quantgroup.xyqb.risk.entity;


import cn.quantgroup.xyqb.entity.enums.Device;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import lombok.Data;
import lombok.ToString;

/**
 * 统计黑名单
 */
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "LoginInfo.countByPhoneAndDevice",
                        query = "select count(DISTINCT device_id) num ,device from  login_info where phone_no=?1  and device =?2 and device_id != ?3 and  created_at > DATE_ADD(CURRENT_TIMESTAMP(),INTERVAL -90 DAY)",
                        resultClass = CountDevice.class
                )
        }
)
@Data
@ToString
@Entity
public class CountDevice {

    @Id
    @Column(name = "device")
    private Device device;


    @Column(name = "num")
    private Long num;
}
