package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class DetailRegisteredEventListener implements ApplicationListener<RegisterEvent> {


    @Resource
    private IUserDetailService userDetailService;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        User user = userRegisterParam.getUser();

        if (StringUtils.isAnyBlank(userRegisterParam.getName()) ||
                !ValidationUtil.validateChinese(userRegisterParam.getName())) {
            return;
        }
        String phoneNo = userRegisterParam.getPhoneNo();
        String name = userRegisterParam.getName();
        UserDetail userDetail = new UserDetail();
        userDetail.setPhoneNo(phoneNo);
        userDetail.setName(name);
        userDetail.setUserId(user.getId());
        log.info("DetailRegisteredEventListener saveUserDetail, userId:{}, phoneNo:{}, name:{}", user.getId(), phoneNo, name);
        userDetailService.saveUserDetail(userDetail);
    }
}
