package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserDeregisterRecord;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

/**
 * 销户 Repository
 *
 * @author killer
 * @date 2021年12月29日12:05:01
 */
public interface IUserDeregisterRecordRepository extends JpaRepository<UserDeregisterRecord, Long> {

    /**
     * 通过userId查询销户记录
     *
     * @param userId 用户Id
     * @return List<UserDeregisterRecord>
     */
    List<UserDeregisterRecord> findByUserId(Long userId);
}
