package cn.quantgroup.xyqb.service.risk.impl;

import cn.quantgroup.xyqb.entity.enums.KeyType;
import cn.quantgroup.xyqb.risk.entity.WhiteList;
import cn.quantgroup.xyqb.risk.repository.WhiteListRepository;
import cn.quantgroup.xyqb.service.risk.LoginRiskService;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/14 15:07
 * @description：登录风控实现类
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@Service
public class LoginRiskServiceImpl implements LoginRiskService {

    @Resource
    private WhiteListRepository whiteListRepository;

    @Override
    public void addWhiteList(String val, KeyType keyType) {
        log.info("添加用户白名单val:{},keyType:{}", val, keyType);
        Long count = whiteListRepository.countByKeyEqualsAndTypeEqualsAndEnableIsTrue(val, keyType);
        if (count > 0) {
            log.warn("用户白名单已经存在val:{},keyType:{}", val, keyType);
            return;
        }

        WhiteList list = new WhiteList();
        list.setEnable(Boolean.TRUE);
        list.setKey(val);
        list.setType(keyType);

        whiteListRepository.save(list);
    }
}
