package cn.quantgroup.xyqb.controller.middleoffice.login;

import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.middleoffice.common.VerifyTypeEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 注册与登陆
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/login")
public class LoginController {

    @Resource
    private ILoginModule loginModule;


    @PostMapping("/{type}")
    public JsonResult loginFreeAuto(@PathVariable VerifyTypeEnum type,
                                    @RequestParam(required = false, defaultValue = "false") Boolean autoReg,
                                    @RequestParam(required = false, defaultValue = "1") Long channelId,
                                    @RequestParam(required = false) String appChannel,
                                    @RequestParam(required = false) String wechatOpenId,
                                    @RequestParam String phoneNo,
                                    @RequestParam(required = false) String verify,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId
    ) {
        LoginVo login = loginModule.login(type, autoReg, channelId, appChannel, wechatOpenId, phoneNo, verify,tenantId);
        return JsonResult.buildSuccessResultGeneric(login);
    }

    @PatchMapping("/modify/pwd")
    public JsonResult modifyByPwd(String phoneNo, String password, String passwordNew,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        loginModule.modifyPwd(VerifyTypeEnum.pwd, phoneNo, password, passwordNew,tenantId);
        return JsonResult.buildSuccessResult();
    }

    @PatchMapping("/modify/sms")
    public JsonResult modifyBySms(String phoneNo, String password, String verificationCode,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        loginModule.modifyPwd(VerifyTypeEnum.sms, phoneNo, password, verificationCode,tenantId);
        return JsonResult.buildSuccessResult();
    }

}
