package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Locale;
import java.util.Map;

/**
 * 公司自有验证码模式
 */
@Service
@Slf4j
public class QuantGroupBehaviorStrategy implements BehaviorStrategy {
    @Autowired
    @Qualifier("customCaptchaService")
    private AbstractManageableImageCaptchaService imageCaptchaService;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private IQuantgroupCaptchaService quantgroupCaptchaService;

    @Override
    public Integer getType() {
        return 2;
    }

    @Override
    public boolean validate(ValidateBehavior validateBehavior) {
        boolean result =  quantgroupCaptchaService.validQuantgroupCaptcha(validateBehavior.getData().get("id"),validateBehavior.getData().get(Constants.X_BEHAVIOR_IMAGEVALUE));
        if(result){
            return true;
        }else{
            throw  new BizException(BizExceptionEnum.FAIL_VERIFY_CODE);
        }
    }


    @Override
    public BehaviorCodeBean generate(BehaviorReq behaviorReq) {
        BehaviorCodeBean behaviorCodeBean = new BehaviorCodeBean();
        Map<String, String> challenge = quantgroupCaptchaService.fetchQuantgroupCaptcha(Locale.CHINA);
        if (challenge == null) {
            throw new BizException(BizExceptionEnum.FAIL_GENERATE_IMAGE);
        }
        behaviorCodeBean.setQtCode(BehaviorCodeBean.QtCode.builder().imageData(challenge.get("image")).build());
        behaviorCodeBean.setId(challenge.get("imageId"));
        return behaviorCodeBean;
    }
}
