package cn.quantgroup.xyqb.entity.enums;

import lombok.Getter;

@Getter
public enum Device {


    ANDROID("安卓", "android"),
    IOS("IOS", "ios"),
    OTHER("other", "other");

    private String desc;
    private String code;

    Device(String desc, String code) {
        this.desc = desc;
        this.code = code;
    }

    public static Device valueOfCode(String code) {
        if (null == code || "".equals(code)) {
            return Device.OTHER;
        }
        for (Device device : Device.values()) {
            if (device.code.equals(code)) {
                return device;
            }
        }
        return null;
    }

}
