package cn.quantgroup.xyqb.controller.internal.user.center;

import cn.quantgroup.user.enums.*;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.limit.PasswordFreeAccessValidator;
import cn.quantgroup.xyqb.aspect.lock.RedisLock;
import cn.quantgroup.xyqb.entity.*;
import cn.quantgroup.xyqb.event.UserExtInfoSaveEvent;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.*;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by 11 on 2017/3/22.
 */
@Slf4j
@RestController
@RequestMapping("/oauthClient")
public class OauthClientDetailsController {
    @Autowired
    private IOauthClientDetailsService oauthClientDetailsService;

    @Autowired
    private IOauthLoginInfoService oauthLoginInfoService;

    @PostMapping("/getOauthClient")
    public JsonResult getOauthClient(Long clientId) {
        OauthClientDetailsEntity oauthClientDetailsEntity = oauthClientDetailsService.findFirstByClientId(clientId);
        return JsonResult.buildSuccessResultGeneric(oauthClientDetailsEntity);
    }

    @PostMapping("/addLoginInfo")
    public JsonResult addLoginInfo(Long tenantId, String phoneNo) {
        User user = new User();
        user.setPhoneNo(phoneNo);
        user.setId(new Long("111111"));
        oauthLoginInfoService.addLoginInfo(user, tenantId);
        return JsonResult.buildSuccessResultGeneric("12");
    }

}
