package cn.quantgroup.xyqb.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Data
@Entity
@Table(name = "user_hash_mapping")
public class UserHashMapping implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no_md5")
    private String phoneNoMd5;

    @Column(name = "id_no_md5")
    private String idNoMd5;

    @Column(name = "phone_no_md5_short")
    private Long phoneNoMd5Short;

    @Column(name = "id_no_md5_short")
    private Long idNoMd5Short;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}